/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Server;
import cds.aladin.TapManager;
import cds.aladin.UWSFacade;
import cds.tools.MultiPartPostOutputStream;
import cds.tools.Util;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.font.TextAttribute;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextPane;

public class UWSJob
implements ActionListener {
    public static final String PHASEACTION_RUN = "RUN";
    public static final String PHASEACTION_ABORT = "ABORT";
    public static final String PENDING = "PENDING";
    public static final String HELD = "HELD";
    public static final String EXECUTING = "EXECUTING";
    public static final String QUEUED = "QUEUED";
    public static final String UNKNOWN = "UNKNOWN";
    public static final String SUSPENDED = "SUSPENDED";
    public static final String COMPLETED = "COMPLETED";
    public static final String ARCHIVED = "ARCHIVED";
    public static final String ERROR = "ERROR";
    public static final String ABORTED = "ABORTED";
    private String serverLabel;
    private double version;
    private URL location;
    private String jobId;
    private String runId;
    private String ownerId;
    private String currentPhase;
    private String quote;
    private String creationTime;
    private String startTime;
    private String endTime;
    private long executionDuration;
    private String destructionTime;
    private Map<String, String> parameters;
    private Map<String, String> results;
    private String errorType;
    private boolean hasErrorDetail;
    private String errorMessage;
    private StringBuffer errorMessageDetailed;
    private StringBuffer jobInfoXml;
    public StringBuffer responseBody;
    public JRadioButton gui;
    public JLabel notificationLabel;
    public JPanel jobDetails;
    private String query;
    private boolean deleteOnExit;
    String notificationText = "";
    public JComboBox displayResults;
    public static final String JOBNOTFOUND = "Not found ;ERROR_404";
    public static final String UNEXPECTEDERROR = "Unexpected Error ";
    public static final String INCORRECTPROTOCOL = "Error incorrect protocol ";
    public UWSFacade uwsFacade;
    public int requestNumber = -1;
    public Server server;

    public UWSJob(UWSFacade uwsFacade, String serverLabel, URL location) {
        this.serverLabel = serverLabel;
        this.location = location;
        this.uwsFacade = uwsFacade;
    }

    public boolean canAbort() {
        boolean result = false;
        result = !this.currentPhase.equals(COMPLETED) && !this.currentPhase.equals(ABORTED) && !this.currentPhase.equals(ERROR) && !this.currentPhase.equals(ARCHIVED);
        return result;
    }

    public boolean canRun() {
        boolean result = false;
        result = this.currentPhase.equals(HELD) || this.currentPhase.equals(PENDING);
        return result;
    }

    public void abortJob() throws Exception {
        HttpURLConnection httpClient = null;
        try {
            httpClient = this.createWritePostData(this.location.toString(), "phase", "PHASE", PHASEACTION_ABORT);
            httpClient.setConnectTimeout(7000);
            String previousPhase = this.currentPhase;
            if (httpClient.getResponseCode() != 303) {
                StringBuffer errorMessage = new StringBuffer("Error when aborting job:\n");
                errorMessage.append("phase: ").append(this.currentPhase);
                if (httpClient.getResponseCode() >= 400) {
                    errorMessage.append("\n").append(Util.handleErrorResponseForTapAndDL(this.location, httpClient));
                }
                httpClient.disconnect();
                this.notificationText = UWSFacade.CANTABORTJOB;
                throw new IOException(errorMessage.toString());
            }
            String locationString = httpClient.getHeaderField("Location");
            this.location = new URL(locationString);
            httpClient.disconnect();
            UWSFacade.populateJob(this.location.openStream(), this);
            this.updateGui(previousPhase);
        }
        catch (IOException e) {
            if (Aladin.levelTrace >= 3) {
                e.printStackTrace();
            }
            throw e;
        }
        finally {
            if (httpClient != null) {
                httpClient.disconnect();
            }
        }
    }

    public void run() throws Exception {
        Aladin.trace(3, "In run. Job phase is:" + this.currentPhase);
        if (this.currentPhase.equals(PENDING) || this.currentPhase.equals(HELD)) {
            HttpURLConnection httpClient = null;
            try {
                httpClient = this.createWritePostData(this.location.toString(), "phase", "PHASE", PHASEACTION_RUN);
                String previousPhase = this.currentPhase;
                if (httpClient.getResponseCode() != 303) {
                    this.currentPhase = "Unexpected Error -Phase: " + this.currentPhase;
                    this.notificationText = UWSFacade.CANTSTARTJOB;
                    StringBuffer errorMessage = new StringBuffer("Error when starting job:\n");
                    errorMessage.append("\n phase: ").append(this.currentPhase);
                    if (httpClient.getResponseCode() >= 400) {
                        errorMessage.append("\n ").append(Util.handleErrorResponseForTapAndDL(this.location, httpClient));
                    }
                    httpClient.disconnect();
                    throw new IOException(errorMessage.toString());
                }
                String locationString = httpClient.getHeaderField("Location");
                this.location = new URL(locationString);
                httpClient.disconnect();
                UWSFacade.populateJob(this.location.openStream(), this);
                this.updateGui(previousPhase);
            }
            catch (IOException e) {
                if (Aladin.levelTrace >= 3) {
                    e.printStackTrace();
                }
                throw e;
            }
            finally {
                if (httpClient != null) {
                    httpClient.disconnect();
                }
            }
        }
        Aladin.trace(3, "run finished. Job phase is:" + this.currentPhase);
    }

    public HttpURLConnection createWritePostData(String baseUrl, String path, String paramName, String paramValue) throws IOException, URISyntaxException {
        HttpURLConnection httpClient = null;
        URL writeUrl = TapManager.getUrl(baseUrl, null, path);
        URLConnection urlConn = MultiPartPostOutputStream.createConnection(writeUrl);
        urlConn.setRequestProperty("Accept", "*/*");
        urlConn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        urlConn.setRequestProperty("Cache-Control", "no-cache");
        String encodedPhaseRunParam = URLEncoder.encode(paramName, "utf-8") + "=" + URLEncoder.encode(paramValue, "utf-8");
        DataOutputStream os = new DataOutputStream(urlConn.getOutputStream());
        os.writeBytes(encodedPhaseRunParam);
        os.close();
        if (!(urlConn instanceof HttpURLConnection)) {
            throw new IOException("Error with job url. Please try again later!\nURL: " + this.location.toString());
        }
        httpClient = (HttpURLConnection)urlConn;
        httpClient.setInstanceFollowRedirects(false);
        return httpClient;
    }

    public void pollForCompletion(Server server, boolean useBlocking, UWSFacade uwsFacade, int requestNumber) throws IOException, InterruptedException, Exception {
        try {
            if (Aladin.levelTrace >= 3) {
                System.out.println("pollForCompletion. Job phase is: " + this.currentPhase);
            }
            URL jobInProgressUrl = this.location;
            String previousPhase = this.currentPhase;
            while (true) {
                if (useBlocking) {
                    boolean bl = useBlocking = this.version != 0.0 && this.version == 1.1;
                    if (useBlocking) {
                        jobInProgressUrl = new URL(this.getBlockingEndPoint());
                    }
                }
                if (this.currentPhase.equals(EXECUTING) || this.currentPhase.equals(QUEUED) || this.currentPhase.equals(SUSPENDED) || this.currentPhase.equals(UNKNOWN)) {
                    URLConnection conn = jobInProgressUrl.openConnection();
                    this.handleJobHttpInterface(conn, 200, "Error for job: \n", false);
                } else {
                    if (this.currentPhase.equals(COMPLETED)) {
                        uwsFacade.loadResults(this, null, requestNumber, server);
                        break;
                    }
                    if (this.currentPhase.equals(ERROR)) {
                        this.showAsErroneous();
                        this.uwsFacade.showAsyncPanel();
                        Aladin.error(uwsFacade.asyncPanel, UWSFacade.JOBERRORTOOLTIP);
                        if (server == null) break;
                        server.setStatusForCurrentRequest(requestNumber, 3);
                        break;
                    }
                    if (!this.currentPhase.equals(PENDING) && !this.currentPhase.equals(HELD)) break;
                    this.run();
                }
                this.updateGui(previousPhase);
                if (useBlocking) continue;
                try {
                    Thread.sleep(4000L);
                }
                catch (InterruptedException e) {
                    if (Aladin.levelTrace < 3) continue;
                    e.printStackTrace();
                }
            }
            this.updateGui(previousPhase);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public void handleJobHttpInterface(URLConnection urlConn, int expectedHttpResponseCode, String genericErrorMessage, boolean setPhaseOnly) throws Exception {
        block10: {
            HttpURLConnection httpConn = null;
            try {
                urlConn = this.location.openConnection();
                if (urlConn instanceof HttpURLConnection) {
                    httpConn = (HttpURLConnection)urlConn;
                    httpConn.setInstanceFollowRedirects(false);
                    if (httpConn.getResponseCode() != expectedHttpResponseCode) {
                        if (httpConn.getResponseCode() == 404) {
                            Aladin.trace(3, "Job is not found, user probably asked for delete: \n" + this.location.toString());
                            this.currentPhase = JOBNOTFOUND;
                            this.notificationText = UWSFacade.JOBNOTFOUNDMESSAGE;
                            throw new IOException(UWSFacade.JOBNOTFOUNDMESSAGE);
                        }
                        this.notificationText = genericErrorMessage + this.location.toString() + "\n phase: " + this.currentPhase;
                        this.currentPhase = "Unexpected Error -Phase: " + this.currentPhase;
                        StringBuffer errorMessage = new StringBuffer(genericErrorMessage);
                        errorMessage.append("\n phase: ").append(this.currentPhase);
                        if (httpConn.getResponseCode() >= 400) {
                            errorMessage.append("\n").append(Util.handleErrorResponseForTapAndDL(this.location, httpConn));
                        }
                        httpConn.disconnect();
                        throw new IOException(errorMessage.toString());
                    }
                    UWSFacade.populateJob(httpConn.getInputStream(), this);
                    httpConn.disconnect();
                    break block10;
                }
                this.notificationText = UWSFacade.ERROR_INCORRECTPROTOCOL;
                this.currentPhase = "Error incorrect protocol -Phase: " + this.currentPhase;
                throw new IOException(UWSFacade.ERROR_INCORRECTPROTOCOL);
            }
            catch (IOException e) {
                throw e;
            }
            finally {
                if (httpConn != null) {
                    httpConn.disconnect();
                }
            }
        }
    }

    public String getBlockingEndPoint() {
        StringBuffer urlInProgress = new StringBuffer(this.location.toString());
        urlInProgress.append("?WAIT=-1&PHASE=" + this.currentPhase);
        return urlInProgress.toString();
    }

    public String getDefaultResultsUrl() throws MalformedURLException, URISyntaxException {
        String result = null;
        URL defaultUrl = TapManager.getUrl(this.getLocation().toString(), null, "/results/result");
        if (defaultUrl != null) {
            result = defaultUrl.toString();
        }
        return result;
    }

    public String getIfSingleResult() {
        String singleResultUrl = null;
        if (this.results != null && this.results.size() == 1) {
            singleResultUrl = this.results.values().iterator().next();
        }
        return singleResultUrl;
    }

    public void setInitialGui() {
        this.gui = new JRadioButton(this.getJobLabel());
        this.gui.setMinimumSize(new Dimension(0, Server.HAUT));
        this.gui.addActionListener(this);
        this.gui.setToolTipText(UWSFacade.UWSJOBRADIOTOOLTIP);
    }

    public String getJobLabel() {
        StringBuffer radioLabel = new StringBuffer("<html><p width=\"1600\">").append(this.currentPhase);
        radioLabel.append(" , Start time: ").append(this.startTime);
        if (this.query != null) {
            radioLabel.append(" , Query: ").append(this.query.replaceAll("&", "&amp;").replaceAll(">", "&gt;").replaceAll("<", "&lt;"));
        }
        radioLabel.append(" ( server: ").append(this.serverLabel).append(")</p></html>");
        return radioLabel.toString();
    }

    public void updateGui(String oldPhase) {
        if ((oldPhase != null && !oldPhase.equals(this.currentPhase) || oldPhase == null) && this.gui != null) {
            this.gui.setText(this.getJobLabel());
            this.gui.revalidate();
            this.gui.repaint();
            if (this.gui.isSelected()) {
                this.setJobDetailsPanel();
            }
            this.uwsFacade.loadResultsbutton.setVisible(COMPLETED.equals(this.currentPhase));
        }
    }

    public synchronized void showAsErroneous() {
        if (this.gui != null) {
            this.gui.setToolTipText(UWSFacade.JOBERRORTOOLTIP);
            this.updateGui(null);
        }
    }

    public synchronized void setJobDetailsPanel() {
        JPanel jobDetails = this.uwsFacade.jobDetails;
        jobDetails.removeAll();
        jobDetails.setLayout(new BoxLayout(jobDetails, 1));
        this.notificationLabel = new JLabel();
        this.notificationLabel.setText(this.notificationText);
        jobDetails.add(this.notificationLabel);
        if (this.results != null && !this.results.isEmpty()) {
            JPanel resultsPanel = new JPanel(new FlowLayout(0));
            resultsPanel.add(new JLabel("Load on Aladin: "));
            this.displayResults = new JComboBox<Object>(this.results.values().toArray());
            resultsPanel.add(this.displayResults);
            resultsPanel.setAlignmentX(0.0f);
            jobDetails.add(resultsPanel);
            JButton loadbutton = new JButton("LOAD");
            loadbutton.setActionCommand("LOADJOBRESULT");
            loadbutton.addActionListener(this);
            resultsPanel.setAlignmentX(0.0f);
            jobDetails.add(loadbutton);
        }
        if (this.errorType != null) {
            JButton button = new JButton("Show error details>>");
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!UWSJob.this.hasErrorDetail) {
                        UWSJob.this.errorMessageDetailed = new StringBuffer("No additional error details available.");
                    } else if (UWSJob.this.hasErrorDetail && (UWSJob.this.errorMessageDetailed == null || UWSJob.this.errorMessageDetailed.length() <= 0)) {
                        UWSJob.this.populateDetailedErrorMessage();
                    }
                    Aladin.info(UWSJob.this.uwsFacade.asyncPanel, UWSJob.this.errorMessageDetailed.toString());
                }
            });
            jobDetails.add(button);
        }
        JTextPane summary = new JTextPane();
        summary.setContentType("text/html");
        summary.setText(this.getResponsetoDisplay());
        summary.setAlignmentX(0.0f);
        summary.setCaretPosition(0);
        jobDetails.add(summary);
        if (!jobDetails.isVisible()) {
            jobDetails.setVisible(true);
        }
        jobDetails.revalidate();
        jobDetails.repaint();
    }

    public void showErrorOnServer() {
        if (this.server != null) {
            this.server.setStatusForCurrentRequest(this.requestNumber, 3);
        }
    }

    public void resetStatusOnServer() {
        if (this.server != null) {
            this.server.setStatusForCurrentRequest(this.requestNumber, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateDetailedErrorMessage() {
        BufferedReader buffReader = null;
        try {
            String response;
            URL errorUrl = new URL(this.location.toString() + "/error");
            buffReader = new BufferedReader(new InputStreamReader(Util.openStream(errorUrl)));
            this.errorMessageDetailed = new StringBuffer("Type: ");
            this.errorMessageDetailed.append(this.errorType).append("\nError message: ").append(this.errorMessage).append("\n Details: \n");
            while ((response = buffReader.readLine()) != null) {
                this.errorMessageDetailed.append(response).append("\n");
            }
        }
        catch (Exception e) {
            if (Aladin.levelTrace >= 3) {
                e.printStackTrace();
            }
            this.errorMessageDetailed = new StringBuffer("No error details available");
        }
        finally {
            block15: {
                if (buffReader != null) {
                    try {
                        buffReader.close();
                    }
                    catch (IOException e) {
                        if (Aladin.levelTrace < 3) break block15;
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public void updateParameters(HashMap<String, String> parameters, String method) {
    }

    public void update(Map<String, String> parameters) {
    }

    public static Font getErrorFont() {
        Font font = Aladin.LPLAIN;
        Map<TextAttribute, ?> fontAttri = font.getAttributes();
        fontAttri.put(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
        return new Font(fontAttri);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String action;
        Object o = event.getSource();
        if (o instanceof JRadioButton && o.equals(this.gui)) {
            this.setJobDetailsPanel();
            this.uwsFacade.deleteOnExit.setVisible(true);
            this.uwsFacade.deleteOnExit.setSelected(this.isDeleteOnExit());
            this.uwsFacade.loadResultsbutton.setVisible(COMPLETED.equals(this.currentPhase));
        } else if (o instanceof JButton && (action = ((JButton)o).getActionCommand()).equals("LOADJOBRESULT")) {
            try {
                this.uwsFacade.loadResults(this, (String)this.displayResults.getSelectedItem(), -1, null);
            }
            catch (MalformedURLException e1) {
                Aladin.error(this.uwsFacade.asyncPanel, "Error in processing results url! Please try with the default tap results url also");
            }
            catch (IOException e1) {
                Aladin.error(this.uwsFacade.asyncPanel, "Unable to get the job information, please try again!");
            }
            catch (Exception e1) {
                Aladin.error(this.uwsFacade.asyncPanel, e1.getMessage());
            }
        }
    }

    public String getResponsetoDisplay() {
        this.responseBody = new StringBuffer("<html><p>");
        if (this.query != null) {
            this.responseBody.append("Job created to execute query: <b>").append(this.query);
        }
        this.responseBody.append("</b><br>Job ID: ").append(this.jobId).append("<br>Run ID: ").append(this.runId).append("<br>URL: <b>").append(this.location.toString()).append("<br></b>Owner ID: ").append(this.ownerId).append("<br>Phase: ").append(this.currentPhase).append("<br>Quote: ").append(this.quote).append("<br>Creation time: ").append(this.creationTime).append("<br>Start time: ").append(this.startTime).append("<br>End time: ").append(this.endTime).append("<br>Execution duration: ").append(this.executionDuration).append("<br>Destruction time: ").append(this.destructionTime);
        if (this.parameters != null && !this.parameters.isEmpty()) {
            this.responseBody.append("<br>Parameters: ").append(this.parameters);
        }
        if (this.results != null && !this.results.isEmpty()) {
            this.responseBody.append("<br>Results: ").append(this.results.toString().replaceAll("&", "&amp;").replaceAll(">", "&gt;").replaceAll("<", "&lt;"));
        }
        if (this.errorType != null) {
            this.responseBody.append("<br>Error type: ").append(this.errorType).append("<br>Error message: ").append(this.errorMessage.replaceAll("&", "&amp;").replaceAll(">", "&gt;").replaceAll("<", "&lt;"));
        }
        if (this.jobInfoXml != null) {
            this.responseBody.append("<br>Job info: ").append(this.jobInfoXml);
        }
        return this.responseBody.toString();
    }

    public double getVersion() {
        return this.version;
    }

    public void setVersion(double version) {
        this.version = version;
    }

    public String getJobId() {
        return this.jobId;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public String getRunId() {
        return this.runId;
    }

    public void setRunId(String runId) {
        this.runId = runId;
    }

    public String getOwnerId() {
        return this.ownerId;
    }

    public void setOwnerId(String ownerId) {
        this.ownerId = ownerId;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public String getEndTime() {
        return this.endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public long getExecutionDuration() {
        return this.executionDuration;
    }

    public void setExecutionDuration(long executionDuration) {
        this.executionDuration = executionDuration;
    }

    public String getDestructionTime() {
        return this.destructionTime;
    }

    public void setDestructionTime(String destructionTime) {
        this.destructionTime = destructionTime;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public Map<String, String> getResults() {
        return this.results;
    }

    public void setResults(Map<String, String> results) {
        this.results = results;
    }

    public String getCurrentPhase() {
        return this.currentPhase;
    }

    public void setCurrentPhase(String currentPhase) {
        this.currentPhase = currentPhase;
    }

    public String getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(String creationTime) {
        this.creationTime = creationTime;
    }

    public URL getLocation() {
        return this.location;
    }

    public void setLocation(URL location) {
        this.location = location;
    }

    public String getServerLabel() {
        return this.serverLabel;
    }

    public void setServerLabel(String serverLabel) {
        this.serverLabel = serverLabel;
    }

    public String getQuote() {
        return this.quote;
    }

    public void setQuote(String quote) {
        this.quote = quote;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public boolean isDeleteOnExit() {
        return this.deleteOnExit;
    }

    public void setDeleteOnExit(boolean deleteOnExit) {
        this.deleteOnExit = deleteOnExit;
    }

    public String getErrorType() {
        return this.errorType;
    }

    public void setErrorType(String errorType) {
        this.errorType = errorType;
    }

    public boolean isHasErrorDetail() {
        return this.hasErrorDetail;
    }

    public void setHasErrorDetail(boolean hasErrorDetail) {
        this.hasErrorDetail = hasErrorDetail;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public StringBuffer getJobInfoXml() {
        return this.jobInfoXml;
    }

    public void setJobInfoXml(StringBuffer jobInfoXml) {
        this.jobInfoXml = jobInfoXml;
    }
}

